/**
 * Created by Huzaifa on 9/18/15.
 */

$(document).on('ready', function() {
    $('#form').valid();
});

$(document).on('change','#source_type,#source_date',function() {
    $('#tblEmployees').find('tbody').html('');
    var $source_type = $('#source_type').val();
    if($source_type=='payroll') {
        $('#divShowDeduction').show('slow');
    } else {
        $('#divShowDeduction').hide('slow');
        $('#show_deduction_no').prop('checked',true);
    }
});

$(document).on('click','#btnSearch',function() {
    var $data = {
        source_type : $('#source_type').val(),
        source_date : $('#source_date').val(),
        bank_id : $('#bank_id').val(),
        department_id : $('#department_id').val(),
        employee_registration_id : $('#employee_registration_id').val(),
        show_deduction : $('input[name="show_deduction"]:checked').val()
    };

    if($data['source_type']=='' || $data['source_date']=='') {
        alert('Source Type && Source Date is required');
    } else {
        $.ajax({
            url: $URLGetData,
            dataType: 'json',
            type: 'post',
            data: $data,
            mimeType:"multipart/form-data",
            beforeSend: function() {
                $('#btnSearch').find('i').removeClass('fa-search').addClass('fa-refresh fa-spin');
                $('#tblEmployees').find('tbody').html('');
            },
            complete: function() {
                $('#btnSearch').find('i').removeClass('fa-refresh fa-spin').addClass('fa-search');
            },
            success: function(json) {
                if(json.success)
                {
                    var cheque_no = parseFloat($('#cheque_no').val()| 0);
                    $.each(json.employees,function(i,$employee) {
                        if(cheque_no > 0 ){
                            fillGrid($employee,cheque_no);
                            cheque_no ++;
                        }else{
                            fillGrid($employee,'');
                        }

                    })
                } else {
                    alert(json.error);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                console.log(xhr.responseText);
            }
        })
    }
});


function fillGrid($employee,$cheque_no) {
    var exists = $('tr[data-registration_id="'+$employee.employee_registration_id+'"]').length;
    //Not Required as already emptying the Grid
    var $check_date = $('#cheque_date').val();
    if(!exists) {
        var $html = '';
        $html += '<tr id="grid_row_'+$grid_row+'" data-employee_registration_id="'+$employee['employee_registration_id']+'">';
        $html += '<td>';
        $html += '  <button type="button" class="btn btn-xs btn-danger" onclick="removeRow('+$grid_row+')"><i class="fa fa-times"></i></button>';
        $html += '</td>';
        $html += '<td>';
        $html += '<input type="hidden" name="employees['+$grid_row+'][source_table]" value="'+$employee['source_table']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][source_table_id]" value="'+$employee['source_table_id']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][employee_registration_id]" value="'+$employee['employee_registration_id']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][employee_id]" value="'+$employee['employee_id']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][employee_code]" value="'+$employee['employee_code']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][registration_code]" value="'+$employee['registration_code']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][bank_id]" value="'+$employee['bank_id']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][bank_name]" value="'+$employee['bank_name']+'" />';
        $html += '<input type="hidden" name="employees['+$grid_row+'][bank_iban]" value="'+$employee['bank_iban']+'" />';
        if($employee['employee_name'] != '') {
            $html += '<input type="text"   name="employees['+$grid_row+'][employee_name]" value="'+$employee['employee_code']+' / '+$employee['registration_code']+' - '+$employee['employee_name']+'" class="form-control" readonly/>';
            $html += '<input type="hidden" name="employees['+$grid_row+'][bank_title]" value="'+$employee['bank_title']+'" class="form-control" readonly/>';
        } else {
            $html += '<input type="hidden" name="employees['+$grid_row+'][employee_name]" value="" class="form-control" readonly/>';
            $html += '<input type="text" name="employees['+$grid_row+'][bank_title]" value="'+$employee['bank_title']+'" class="form-control" readonly/>';
        }
        $html += '</td>';
        $html += '<td>';
        $html += '<input type="text"   name="employees['+$grid_row+'][cheque_date]" value="'+$check_date+'" class="form-control dtpDate" required/>';
        $html += '</td>';
        $html += '<td>';
        $html += '<input type="text"   name="employees['+$grid_row+'][cheque_no]" value="'+$cheque_no+'" class="form-control" required/>';
        $html += '</td>';
        $html += '<td>';
        $html += '<input type="text"   name="employees['+$grid_row+'][cheque_amount]" value="'+$employee['cheque_amount']+'" class="form-control text-right amount" readonly/>';
        $html += '</td>';
        $html += '</tr>';


        $('#tblEmployees').find('tbody').append($html);
        calcTotal();
        $grid_row++;
    }
}


function removeRow($row_id) {
    $('#tblEmployees').find('#grid_row_'+$row_id).remove();
    calcTotal();
}

function calcTotal() {
    var $total_employee=0;
    var $total_amount=0;
    $('#tblEmployees .amount').each(function() {
        var $amount = parseFloat($(this).val()) | 0;

        $total_amount += $amount;
        $total_employee++;
    });

    $('#total_amount').val($total_amount);
    $('#total_employee').val($total_employee);
}


// JS for Post Account
$(document).on('change','#pay_from_company_id',function() {
    //console.log(this);
    $('#tblAccounts').find('tbody').html('');
    $('#tblBudgets').find('tbody').html('');
});

$(document).on('click','#btnGetPostData',function() {

    var $paydate = $('#pay_date').val();
    if($paydate == '')
    {
        alert('Please select pay date');
        return false;
    }

    var $source_type = $('#source_type').val();
    //var $company_id = $('#pay_from_company_id option:selected').data('ref_id');
    var $company_id = $('#pay_from_company_id').val();

    $.ajax({
        url: $URLGetAccountsData,
        dataType: 'json',
        type: 'post',
        data: 'source_type='+$source_type+'&Comp='+$company_id+'&pay_date='+$paydate,
        mimeType:"multipart/form-data",
        beforeSend: function() {
            $('#btnGetPostData').find('i').removeClass('fa-search').addClass('fa-refresh fa-spin');
            $('#tblAccounts').find('tbody').html('');
            $('#tblBudgets').find('tbody').html('');
        },
        complete: function() {
            $('#btnGetPostData').find('i').removeClass('fa-refresh fa-spin').addClass('fa-search');
        },
        success: function(json) {
            if(json.success)
            {
                var $accounts = json.accounts;
                var $budgets = json.budgets;

                var $grid_row=0;
                $.each($accounts, function(i,$account) {
                    var $html = '';
                    $html += '<tr>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][PayDate]" value="'+$account['PayDate']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Syskey]" value="'+$account['SysKey']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][SysTag]" value="'+$account['SysTag']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Year]" value="'+$account['Year']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control comp" name="account_details['+$grid_row+'][Comp]" value="'+$account['Comp']+'" readonly/></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" required="true" name="account_details['+$grid_row+'][PartyID]" value="'+$account['PartyID']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Party]" value="'+$account['Party']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][tran_type]" value="'+$account['tran_type']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][BAHKey]" value="'+$account['BAHKey']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][AHKey]" value="'+$account['AHKey']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][CCKey]" value="'+$account['CCKey']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][BudKey]" value="'+$account['BudKey']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Narr]" value="'+$account['Narr']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Ref]" value="'+$account['Ref']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][taxType]" value="'+$account['taxType']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Pamount]" value="'+$account['Pamount']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Bamount]" value="'+$account['Bamount']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="account_details['+$grid_row+'][Ctrl_No]" value="'+$account['Ctrl_No']+'" /></td>';
                    $html += '</tr>';

                    $('#tblAccounts').find('tbody').append($html);
                    $grid_row++
                });

                $grid_row=0;
                $.each($budgets, function(i,$budget) {
                    var $html = '';
                    $html += '<tr>';
                    $html += '<td class="text-center"><input type="text" class="form-control comp" name="budgets['+$grid_row+'][Comp]" value="'+$budget['Comp']+'" readonly /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="budgets['+$grid_row+'][Year]" value="'+$budget['Year']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" required="true" onfocusout="check(this);" name="budgets['+$grid_row+'][BudKey]" value="'+$budget['BudKey']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="budgets['+$grid_row+'][Ref]" value="'+$budget['Ref']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="budgets['+$grid_row+'][budAmt]" value="'+$budget['budAmount']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="budgets['+$grid_row+'][Status]" value="'+$budget['Status']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" required="true" name="budgets['+$grid_row+'][PartyID]" value="'+$budget['PartyID']+'" /></td>';
                    $html += '<td class="text-center"><input type="text" class="form-control" name="budgets['+$grid_row+'][AHKey]" value="'+$budget['AHKey']+'" /></td>';
                    $html += '</tr>';

                    $('#tblBudgets').find('tbody').append($html);
                    $grid_row++;
                })
            } else {
                alert(json.error);
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    })
});